# 快速上手 Vibe Coding

> 10 分钟做出你的第一个网页应用并部署上线



你好，我是程序员鱼皮，前腾讯全栈开发，全网 200 万粉的 [AI 编程博主](https://space.bilibili.com/12890453)，也是 [AI 导航](https://ai.codefather.cn) 和 [编程导航](https://www.codefather.cn) 等 10+ 自研产品的创造者。

在上一篇文章中，我们聊了 Vibe Coding 的理念和思维方式。现在，是时候动手实践了！

这篇文章，我会手把手带你在 10 分钟内做出你的第一个网页应用，并且把它部署到互联网上，让全世界的人都能访问。

是的，你没听错，不需要你有任何编程基础，只要你会打字、会上网，就能跟着做。



## 一、准备工作

在开始之前，我们需要做一些简单的准备。别担心，这些都很简单，5 分钟就能搞定。

需要准备的东西：

1. 一台能上网的电脑（Windows、Mac 都可以）
2. 一个浏览器（Chrome、Edge、Safari 都行）
3. 一个 AI 工具账号（我们用 Bolt.new，免费的）
4. 一个 GitHub 账号（用来部署，也是免费的）

就这些，不需要安装任何编程软件，不需要学任何代码，一切都在浏览器里完成。

💡 什么是 GitHub？

[GitHub](https://github.com/) 是目前最主流的、免费的代码开源托管平台 ，可以理解为一个存储和管理代码的 “网盘”。所有用户或团队都可以把自己的代码上传到 GitHub 进行共享和维护、从 GitHub 下载代码等。开发者们可以从 GitHub 上白票代码，进行学习或引用。

如果你对 GitHub 感兴趣，可以看 [鱼皮的保姆级 GitHub 学习路线](https://www.codefather.cn/course/1789189862986850306/section/1789190804671012866) 免费学习。



### 如何选择 AI 工具？

对于完全零基础的新手，我强烈推荐从 Bolt.new 开始。它完全在线，不需要安装任何软件，打开浏览器就能用。而且最棒的是，你写完代码立刻就能看到效果，做完后一键发布到网上，完全零门槛。还有免费额度，够新手练习了。

等你熟练了，再去学习 Cursor 这样的专业工具也不迟。

注意，如果你的网络无法访问 Bolt.new，也可以尝试 [美团 NoCode](https://nocode.cn/) 或者 [百度秒哒](https://www.miaoda.cn/)，都是类似的 AI 应用生成平台。



### 注册 Bolt.new

1）打开浏览器，访问：https://bolt.new

2）点击右上角的 "Sign in" 按钮

3）可以选择用 Google 账号 / GitHub 账号 / 邮箱密码登录（推荐用 GitHub，后面部署会用到）

登录成功后，准备工作就完成了。接下来你就可以在对话框中输入需求来生成项目了。

![](https://pic.yupi.icu/1/image-20260104140815455.png)



## 二、选择你的第一个项目

第一个项目很重要，它直接决定了你的学习体验。我建议选择一个简单但完整的项目，最好有实际用处，能看到效果。

根据我的经验，下面这几个项目比较适合新手，都是能轻松完成的。

1）个人名片网页：展示你的名字、头像、自我介绍和联系方式，简洁美观。适合想快速体验成就感的朋友。

2）待办事项应用：一个简单的任务管理工具（俗称 Todo List），可以添加任务、标记完成、删除任务。适合想做点儿实用工具的朋友。

3）倒计时网页：可以设置目标日期（比如考试、生日），实时显示剩余天数，有漂亮的视觉效果。适合想做点有创意的东西的朋友。

在这篇教程中，我会以经典的 **待办事项应用** 为例，因为它功能完整、实用性强，而且能让你体验到完整的开发流程。如果你想做其他项目也完全没问题，步骤是一样的，只需要把需求描述换成你想要的就行。



## 三、和 AI 对话生成代码

好了，现在开始最激动人心的部分 —— 和 AI 对话，让它帮你生成代码。


### 第 1 轮对话：描述基本需求

在 Bolt.new 的聊天框里，输入以下内容（你可以直接复制）：

```
请帮我做一个待办事项应用网页，要求：

1. 功能需求：
   - 可以输入任务内容并添加到列表
   - 每个任务前面有个复选框，点击可以标记完成
   - 已完成的任务显示删除线
   - 每个任务后面有删除按钮
   - 显示已完成和未完成的任务数量

2. 界面要求：
   - 简洁现代的设计风格
   - 使用清新的蓝色调
   - 圆角按钮和输入框
   - 适当的阴影效果
   - 响应式设计，手机上也能正常使用

3. 技术要求：
   - 使用 HTML + CSS + JavaScript
   - 数据保存在浏览器本地存储，刷新页面不会丢失
```

你还可以选择大模型、使用计划模式、添加附件、增强提示词等等，但是我建议刚开始不用关注这些，直接点击发送，然后等待 AI 的回应即可。

![](https://pic.yupi.icu/1/image-20260104141314370.png)




### AI 在做什么？

发送后，你会看到 Bolt.new 开始工作。

AI 理解了你的需求，然后创建项目文件结构，再自动生成网页代码，整个过程大约需要 2 分钟。

![](https://pic.yupi.icu/1/image-20260104141512389.png)

代码生成完成后，右侧会自动显示预览效果。你会看到一个输入框、一个添加按钮、任务列表区域。

试着在输入框里输入 "跟鱼皮学习 Vibe Coding"，然后点击添加按钮，看看效果。

![](https://pic.yupi.icu/1/image-20260104141637255.png)




### 第 2 轮对话：优化细节

看到初版效果后，你可能会想调整一些细节。比如：

```
很好！但我想做一些调整：

1. 输入框的占位符文字改成 "今天要做什么？"
2. 添加按钮改成 "➕ 添加任务"
3. 标题改成 "我的待办清单"，并加个可爱的图标
4. 背景色改成渐变色，从浅蓝到浅紫
5. 添加一个 "清空已完成" 的按钮
```

还可以开启可视化修改功能，选中你想要修改的元素，哪里不爽点哪里~

![](https://pic.yupi.icu/1/image-20260104141819294.png)

AI 会根据你的要求修改代码，很快你就能看到新效果。

![](https://pic.yupi.icu/1/image-20260104142026165.png)




### 第 3 轮对话：添加新功能

如果你想添加更多功能，继续和 AI 对话：

```
再加几个功能：

1. 任务可以设置优先级（高、中、低），用不同颜色标识
2. 可以编辑已添加的任务
3. 添加一个 "全部清空" 按钮，并要求确认
4. 任务列表为空时，显示一个友好的提示
```

AI 会继续帮你实现这些功能。

![](https://pic.yupi.icu/1/image-20260104142238907.png)




### 对话技巧

在和 AI 对话时，记住这几点：

1. 需求要具体：不要说 “做得好看一点”，要说 “背景改成蓝色渐变，按钮加圆角”
2. 一次不要改太多：每次提 1~5 个要求就够了，改完看效果再继续
3. 遇到问题直接说：如果有 bug 或者效果不对，直接告诉 AI “XX 这里有问题”
4. 可以要求解释：不懂的地方，可以问 “这段代码是做什么的？”



## 四、验证效果

现在，你的待办事项应用已经做好了。让我们测试一下各个功能：

1）在输入框输入 "跟鱼皮学习 Vibe Coding"，点击添加按钮，任务出现在列表中

2）点击任务前的复选框，任务文字显示删除线；点击删除按钮，任务从列表中消失。

最后点击预览窗口上方的设备图标，看看在手机和不同屏幕上的效果。

![](https://pic.yupi.icu/1/image-20260104142538383.png)

如果发现某个功能无法正常使用，不要慌。把问题详细描述给 AI，比如 "我点击删除按钮后，任务没有被删除"，AI 会帮你修复 Bug，然后重新测试就好了。

这就是 Vibe Coding 的魅力 —— 遇到问题，AI 帮你解决！



## 五、部署上线

做完了应用，现在让我们把它发布到互联网上，让全世界的人都能访问！

### 快速部署（推荐）

Bolt.new 提供了最简单的部署方式，只需要点击右上角的 "Publish" 按钮，点击发布：

![](https://pic.yupi.icu/1/image-20260104142853639.png)

然后稍等片刻，就能在聊天框中看到发布后的可访问地址了：

![](https://pic.yupi.icu/1/image-20260104142912318.png)

部署成功后，你应该能在任何浏览器访问你的应用，或者把地址分享给朋友让他们也能访问。

恭喜，你的第一个网页应用已经上线了，就这么简单！🎉

💡 如果你觉得这个地址比较丑，Bolt.new 还支持自定义域名，但是仅高级版可用，我觉得没必要。



### 扩展知识 - 手动部署

鱼皮分享过多种快速部署上线项目的视频教程：

- [Vercel 项目部署教程](https://www.bilibili.com/video/BV1TV4y1j76t)
- [云端编辑器 + Vercel + 对象存储 + 内网穿透 4 种方式部署](https://www.bilibili.com/video/BV1UZ4y197i1)
- [Nginx + 宝塔 2 种方式部署个人博客](https://www.bilibili.com/video/BV1rU4y1J785)
- [WordPress 搭建个人博客](https://www.bilibili.com/video/BV14q4y1R7XM)
- [4 种主流前后端项目部署](https://www.codefather.cn/course/1790943469757837313/section/1791075571845345281?contentType=video&tabKey=videoList)

此外，鱼皮在 [编程导航](https://codefather.cn/) 带大家做过 20 多套项目了，几乎每种部署方式都给大家讲解过，如果你想成为一名专业的程序员，建议学习一下。

- [AI 零代码应用生成平台项目](https://www.codefather.cn/course/1948291549923344386)：1Panel 面板 + Nginx 前端 + Java 后端（jar 包）
- [代码生成器共享平台项目](https://www.codefather.cn/course/1790980795074654209)：宝塔面板 + Nginx 前端 + Java 项目管理器（jar 包）后端部署
- [AI 答题应用平台项目](https://www.code-nav.cn/course/1790274408835506178)： Vercel 前端 + Docker 后端 + 云托管 Serverless 平台部署
- [AI 超级智能体项目](https://www.codefather.cn/course/1915010091721236482)：Docker 前端 + Docker 后端 + 云托管 Serverless 平台部署
- [OJ 在线判题项目](https://www.codefather.cn/course/1790980707917017089)：Docker Compose 后端微服务部署

基本上学会这几种部署方式，能够应对绝大多数部署需求了。



## 六、理解你做的东西

做完了项目，让我们花几分钟理解一下你做的东西，这样能帮你日后做出更好的项目。




### 项目结构

首先，你要知道网页应用的基础是 "前端三件套"：

- HTML（结构）：定义了页面有哪些元素，比如输入框、按钮、任务列表、统计信息。
- CSS（样式）：定义了页面长什么样，包括颜色、字体、大小、布局和间距、动画效果。
- JavaScript（功能）：定义了页面怎么工作，包括添加任务、标记完成、删除任务、本地存储的逻辑。

不过，在这个项目中，AI 选择了使用 **React** 这个现代化的前端开发框架来帮你实现功能。React 是目前最流行的前端框架之一，它让开发更高效、代码更容易维护。

所以你会在项目文件中看到 `.tsx` 后缀的文件，这些就是 React 组件文件。但本质上，它们最终还是会被转换成浏览器能理解的 HTML、CSS 和 JavaScript。

![](https://pic.yupi.icu/1/image-20260104162356144.png)

没事，现在不理解也完全没关系。如果对前端开发感兴趣的同学，可以看 [鱼皮最新的保姆级前端学习路线](https://www.codefather.cn/course/1789189862986850306/section/1789190394078011393) 快速入门。




### 核心功能解析（可跳过）

让我们看看几个关键功能是怎么实现的：

1）添加任务：当你点击 "添加任务" 按钮时，程序会先获取输入框里的文字，然后创建一个新的任务对象，把任务添加到列表里，同时保存到本地存储，最后清空输入框并刷新页面显示。整个过程就像你在纸上写下一个待办事项，然后把它贴到墙上一样自然。

2）标记完成：当你点击复选框时，程序会找到对应的任务，修改它的完成状态，更新本地存储，然后更新页面显示（给任务文字加上删除线），同时更新统计数字。就像你用笔在纸上的任务上划了一道线。

3）本地存储

你可能会好奇，为什么刷新页面任务还在？

这是因为数据保存在浏览器的本地存储（localStorage）里。每次你修改任务，程序都会把最新的数据保存到 localStorage；当你重新打开页面时，程序会从 localStorage 读取之前保存的数据。这样即使关闭浏览器，数据也不会丢失。就像你把待办清单写在了一个不会丢的小本子上。

![](https://pic.yupi.icu/1/theoryofworksoftware%E5%A4%A7.jpeg)



### 向 AI 请教

如果你想深入理解某个部分，可以直接问 AI：

```
请解释一下本地存储是怎么工作的？
```

或者：

```
这段代码是做什么的？
[粘贴代码]
```

AI 会用通俗易懂的语言给你解释。



## 七、尝试修改和优化

现在你已经有了一个实用的小软件，让我们尝试一些修改和优化，加深理解。

你可以试试：

- 改变颜色主题（"把应用改成粉色主题，温柔可爱的感觉"）
- 修改文字（"把所有文字改成英文版本"）
- 调整布局（"把统计信息移到页面底部，并居中显示"）

或者添加新功能，比如：

- 任务搜索（"添加一个搜索框，可以搜索任务内容"）
- 任务分类（"添加分类功能，可以给任务添加标签"）
- 导出功能（"添加一个按钮，可以把所有任务导出为文本文件"）

还可以优化用户体验，让应用更好用：

- 添加快捷键（"按回车键可以快速添加任务"）
- 添加动画（"添加任务时有一个淡入动画，删除任务时有一个滑出动画"）
- 空状态优化（"当没有任务时，显示一个可爱的插图和鼓励文字"）。

如果你觉得简单，可以尝试添加：

- 截止日期功能
- 任务提醒功能
- 支持拖拽排序
- 添加深色模式切换
- 支持多个任务列表

每次想添加新功能，就和 AI 说 "我想添加 [功能描述]，应该怎么做？"，AI 会帮你实现。



## 写在最后

恭喜，你已经完成了 Vibe Coding 的第一次实战。

你刚才做的事情，在几年前需要几个月的学习才能完成。但在今天，你只用了 10 分钟！这就是 Vibe Coding 的力量。

通过这个项目，你学会了如何清晰地向 AI 描述需求、通过多轮对话不断优化项目、遇到问题如何跟 AI 协作解决，还学会了如何把项目发布到互联网。虽然你没有写代码，但你已经理解了网页应用的基本结构、用户交互的实现方式、数据存储的基本概念。

更重要的是，你建立了 Vibe Coding 的思维方式：**关注 "要做什么" 而不是 "怎么做"**，先做出来再不断优化，在做项目中学习而不是先学再做，把 AI 当作编程伙伴而不是工具。

这只是开始，随着你做的项目越来越多，你会发现你的需求表达能力越来越强、对技术的理解越来越深、能做的东西越来越复杂、创造力得到了真正的释放。

记住我在第一篇文章里说的：**在 AI 时代，创造力比技术更重要，想法比实现更重要，迭代比完美更重要。**



### 下一步建议

接下来，建议你再做 2 ~ 3 个类似难度的项目来巩固练习，比如个人名片网页、倒计时应用、简单计算器、天气查询工具。

实践是最好的老师，只有真正动手做，你才能真正理解 Vibe Coding 的魅力。

当你熟练了 Bolt.new 平台和简单项目的开发后，可以直接继续学习本教程的后续内容：

- 【进阶选学】编程工具
- 【进阶选学】项目实战
- 【进阶选学】经验技巧
- 【进阶选学】资源宝库

也可以先简单了解 Cursor（更专业的 AI 代码编辑器）、GitHub（代码管理和协作）、更多部署平台等等。

加油，你一定可以的！💪




## 推荐资源

1）鱼皮 AI 导航网站：[AI 资源大全、最新 AI 资讯、免费 AI 教程](https://ai.codefather.cn)

2）编程导航学习圈：[学习路线、编程教程、实战项目、求职宝典、交流答疑](https://www.codefather.cn)

3）程序员面试八股文：[实习/校招/社招高频考点、企业真题解析](https://www.mianshiya.com)

4）程序员写简历神器：[专业模板、丰富例句、直通面试](https://www.laoyujianli.com)

5）1 对 1 模拟面试：[实习/校招/社招面试拿 Offer 必备](https://ai.mianshiya.com)
